<?php
//セッションの開始
session_start();
//関数モジュールファイルを読み込む
require_once("FunctionClass.php");
$fc = new FunctionClass();
//.htpasswdファイルを読み込む
$hashes = $fc->getHtpasswdArray("../");
//ログインフォームの情報を取得する
$account_id =  filter_input(INPUT_POST, 'account_id');
$password = filter_input(INPUT_POST, 'password');

/**
 * 入力チェック
 */
if ($account_id == "" || $password == "") {
  $_SESSION["ERR_MSG"] = "ERR";
  header("Location:../login.html");
  exit();
}

/**
 * 認証チェック
 */
if (
  !isset($account_id, $password) ||
  !password_verify(
    $password,
    isset($hashes[$account_id])
      ? $hashes[$account_id]
      : '$1$c6068b32$9hGXGoMtRmB/dL0jL9rx5.' // ダミーデータを設定
  )
) {
  $_SESSION["ERR_MSG"] = "ERR";
  header("Location:../login.html");
  exit();
}

/**
 * ログイン後のページに遷移する
 */
unset($_SESSION["ERR_MSG"]);
$_SESSION["LOGIN_STATAS"] = true;
//ログイン後に遷移するページ（適宜変更ください。）
header("Location:../index.html");
exit();
