$(function () {
  //初期処理
});

/**
 *
 *
 * レコードの削除
 *
 *
 */

$(".rec_delete").on("click", function () {
  let id = $(this).attr("data-id");
  swal
    .fire({
      title: "Delete Account",
      html: "May I delete an account?",
      icon: "info",
      confirmButtonText: "Confirm",
      showCancelButton: true,
      cancelButtonText: "Cancel",
    })
    .then((result) => {
      if (result.isConfirmed) {
        if (delete_email(id) == true) {
          swal
            .fire({
              title: "Delete Account",
              html: "Account has been deleted.",
              icon: "success",
              showCloseButton: true,
              confirmButtonText: "OK",
            })
            .then(function (val) {
              $("#row" + id).remove();
            });
        } else {
          alert("d");
        }
      } else {
      }
    });
});

$(function () {
  /**
   *
   *
   * レコードの登録
   *
   */
  $("#create").on("click", function () {
    let param = $("#entry_form").serializeArray();
    let email = $("#email_field").val();
    if ($("#entry_form").length > 0) {
      $.validator.addMethod("chk_email", function (value, element) {
        if (this.optional(element)) {
          return true;
        }
        if (check_email("entry") == "ok") {
          return true;
        } else {
          return false;
        }
      });

      $("#entry_form").validate({
        rules: {
          name: "required",
          email: {
            required: true,
            email: true,
            chk_email: true,
          },
          pass: {
            required: true,
          },
          status: {
            required: true,
          },
        },
        messages: {
          name: "Enter account name",
          pass: {
            required: "Enter account password",
          },
          email: {
            required: "Enter account email",
            email: "Email format is incorrect",
            chk_email: "Registered email address",
          },
          status: {
            required: "Enter account status",
          },
        },

        errorPlacement: function (error, element) {
          if (element.is(":radio, :checkbox")) {
            error.appendTo(".custom_errmsg");
          } else {
            error.insertAfter(element);
          }
        },

        submitHandler: function (form) {
          let fd = new FormData();
          fd.append("proc", $("#proc").val());
          fd.append("name", $("#name_field").val());
          fd.append("email", $("#email_field").val());
          fd.append("pass", $("#password_field").val());
          fd.append("status", $('input[name="status"]:checked').val());
          fd.append("POST_TOKEN", $("#POST_TOKEN").val());

          swal
            .fire({
              title: "Create Account",
              html: "May I create an account?",
              icon: "info",
              confirmButtonText: "Confirm",
              showCancelButton: true,
              cancelButtonText: "Cancel",
            })
            .then((result) => {
              if (result.isConfirmed) {
                $.ajax({
                  type: "POST",
                  url: "proc/insert.php",
                  data: fd,
                  cache: false,
                  processData: false,
                  contentType: false,
                  dataType: "html",
                })
                  .done(function (data) {
                    swal
                      .fire({
                        title: "Create Account",
                        html: "Account has been created.",
                        icon: "success",
                        showCloseButton: true,
                        confirmButtonText: "OK",
                      })
                      .then(function (val) {
                        if (val) {
                          location.href = "index.html";
                        } else {
                        }
                      });
                  })

                  .fail(function (XMLHttpRequest, textStatus, errorThrown) {
                    console.log(textStatus);
                    console.log(errorThrown);
                    swal.fire({
                      title: "ABEND",
                      text: "The process ended abnormally.",
                      icon: "error",
                      showCloseButton: true,
                    });
                  });
              } else {
              }
            });
        }, //submitHandler
      }); //validate
    } else {
      alert("dd");
    } //if
  }); //click

  $("#edit").on("click", function () {
    let param = $("#edit_form").serializeArray();
    let email = $("#email_field").val();
    if ($("#edit_form").length > 0) {
      $.validator.addMethod("chk_email", function (value, element) {
        if (this.optional(element)) {
          return true;
        }
        if (check_email("edit") == "ok") {
          return true;
        } else {
          return false;
        }
      });

      $("#edit_form").validate({
        rules: {
          name: {
            required: true,
            minlength: 4,
          },
          email: {
            required: true,
            email: true,
            chk_email: true,
          },
          status: {
            required: true,
          },
        },
        messages: {
          name: {
            required: "Enter account name",
            minlength: "Enter 4 or more characters",
          },
          email: {
            required: "Enter account email",
            email: "Email format is incorrect",
            chk_email: "Registered email address",
          },
          status: {
            required: "Enter account status",
          },
        },

        errorPlacement: function (error, element) {
          if (element.is(":radio, :checkbox")) {
            error.appendTo(".custom_errmsg");
          } else {
            error.insertAfter(element);
          }
        },

        submitHandler: function (form) {
          let fd = new FormData();
          fd.append("id", $("#id").val());
          fd.append("name", $("#name_field").val());
          fd.append("email", $("#email_field").val());
          fd.append("status", $('input[name="status"]:checked').val());
          fd.append("POST_TOKEN", $("#POST_TOKEN").val());
          swal
            .fire({
              title: "Edit Account",
              html: "May I edit an account?",
              icon: "info",
              confirmButtonText: "Confirm",
              showCancelButton: true,
              cancelButtonText: "Cancel",
            })
            .then((result) => {
              if (result.isConfirmed) {
                $.ajax({
                  type: "POST",
                  url: "proc/update.php",
                  data: fd,
                  async: false,
                  processData: false,
                  contentType: false,
                  dataType: "html",
                })
                  .done(function (data) {
                    swal
                      .fire({
                        title: "Edit Account",
                        html: "Account has been edited.",
                        icon: "success",
                        showCloseButton: true,
                        confirmButtonText: "OK",
                      })
                      .then(function (val) {
                        if (val) {
                          location.href = "index.html";
                        } else {
                        }
                      });
                  })
                  .fail(function (XMLHttpRequest, textStatus, errorThrown) {
                    swal.fire({
                      title: "ABEND",
                      text: "The process ended abnormally.",
                      icon: "error",
                      showCloseButton: true,
                    });
                  });
              }
            });
        }, //submitHandler
      }); //validate
    } else {
      alert("dd");
    } //if
  }); //click

  $("#new_pass").on("click", function () {
    let param = $("#pass_form").serializeArray();

    if ($("#pass_form").length > 0) {
      var methods = {
        pass_match: function (value, element) {
          return this.optional(element) || $("#pass1").val() == value;
        },
      };

      $("#pass_form").validate({
        rules: {
          pass1: {
            required: true,
            minlength: 8,
          },
          pass2: {
            required: true,
            minlength: 8,
            pass_match: true,
          },
        },
        messages: {
          pass1: {
            required: "Enter New Password",
            minlength: "Enter 8 or more characters",
          },
          pass2: {
            required: "Enter Re Password",
            minlength: "Enter 8 or more characters",
            pass_match: "Password not matched",
          },
        },

        errorPlacement: function (error, element) {
          if (element.is(":radio, :checkbox")) {
            error.appendTo(".custom_errmsg");
          } else {
            error.insertAfter(element);
          }
        },

        submitHandler: function (form) {
          let fd = new FormData();

          fd.append("id", $("#id").val());
          fd.append("pass", $("#pass1").val());
          fd.append("POST_TOKEN", $("#POST_TOKEN").val());
          swal
            .fire({
              title: "New Password",
              html: "May I edit an password?",
              icon: "info",
              confirmButtonText: "Confirm",
              showCancelButton: true,
              cancelButtonText: "Cancel",
            })
            .then((result) => {
              if (result.isConfirmed) {
                $.ajax({
                  type: "POST",
                  url: "proc/update_pass.php",
                  data: fd,
                  async: false,
                  processData: false,
                  contentType: false,
                  dataType: "html",
                })
                  .done(function (data) {
                    swal
                      .fire({
                        title: "New Password",
                        html: "Password has been created.",
                        icon: "success",
                        showCloseButton: true,
                        confirmButtonText: "OK",
                      })
                      .then(function (val) {
                        if (val) {
                          location.href = "index.html";
                        } else {
                        }
                      });
                  })
                  .fail(function (XMLHttpRequest, textStatus, errorThrown) {
                    swal.fire({
                      title: "ABEND",
                      text: "The process ended abnormally.",
                      icon: "error",
                      showCloseButton: true,
                    });
                  });
              }
            });
        }, //submitHandler
      }); //validate

      //独自の検証ルールを追加（基本的に変更しなくてOKです）
      $.each(methods, function (key) {
        $.validator.addMethod(key, this);
      });
    } //if
  }); //click
  /**
   *
   *
   *
   *
   *
   *
   *
   *
   *
   *
   *
   */

  $("#cancel").on("click", function () {
    location.href = "index.html";
  });
}); //function

function check_email(proc) {
  if (proc == "edit") {
    if ($("#email_field").val() == $("#before_email").val()) {
      return "ok";
    }
  }
  var result = $.ajax({
    type: "POST",
    url: "proc/email_check.php",
    data: {
      email: $("#email_field").val(),
    },
    async: false,
    dataType: "text",
  }).responseText;
  return result;
}

function delete_email(id) {
  var result = $.ajax({
    type: "POST",
    url: "proc/delete.php",
    dataType: "text",
    async: false,
    data: {
      id: id,
    },
  }).responseText;
  return true;
}
