<?php
$db = new SQLite3('./user.db');
$db->exec("create table users(id INTEGER PRIMARY KEY AUTOINCREMENT,name text,pass text,email text,status int,create_datetime timestamp NOT NULL default (datetime(CURRENT_TIMESTAMP,'localtime')))");


$hash_pass = password_hash('pretty', PASSWORD_DEFAULT);
$db->exec('begin');
try {
  $insert_sql = "";
  $insert_sql .= "insert into users";
  $insert_sql .= "(name,pass,email,status)";
  $insert_sql .= " values ";
  $insert_sql .= "(:name,:pass,:email,:status)";
  $stmt = $db->prepare($insert_sql);
  $stmt->bindValue(':name', 'Hideaki Satoh', SQLITE3_TEXT);
  $stmt->bindValue(':pass', $hash_pass, SQLITE3_TEXT);
  $stmt->bindValue(':email', 'satoh@bitwin.ne.jp', SQLITE3_TEXT);
  $stmt->bindValue(':status', 1, SQLITE3_INTEGER);
  $result = $stmt->execute();
  // COMMIT
  $db->exec('commit');
} catch (Exception $e) {
  // ROLLBACK
  $db->exec('rollback');
  $e->getTraceAsString();
  return;
}


$result = $db->query('SELECT * FROM users');
while ($row = $result->fetchArray()) {
  echo $row[0] . "：" . $row[1] . "：" . $row[2] . "：" . $row[3];
}
$db->close();
