<?php

//セッションの開始
session_start();

/** php.iniの設定 **/
//言語設定
mb_language("Ja");
//文字コード設定
mb_internal_encoding("UTF-8");
//タイムゾーン設定
date_default_timezone_set('Asia/Tokyo');



/** 不正アクセスチェック **/

//トークン(アクセスコード)の一致確認
if (filter_input(INPUT_POST, 'POST_TOKEN') != $_SESSION["POST_TOKEN"]) {
  // トークンが一致しない
  header("Location: index.html");
  exit;
}


//アクセス方法の確認
if ($_SERVER["REQUEST_METHOD"] != "POST") {
  echo "不正アクセスです。"; // ブラウザからHTMLページを要求された場合
  exit;
}

/** 入力内容の取得 **/
// ID
$id = filter_input(INPUT_POST, 'id');
// パスワード
$password_txt = filter_input(INPUT_POST, 'pass');

$db = new SQLite3('../db/user.db');


$hash_pass = password_hash($password_txt, PASSWORD_DEFAULT);
$db->exec('begin');
try {
  $sql = "";
  $sql .= "update users set ";
  $sql .= "pass=:pass";
  $sql .= " where ";
  $sql .= "id=:id";
  $stmt = $db->prepare($sql);
  $stmt->bindValue(':id', $id, SQLITE3_INTEGER);
  $stmt->bindValue(':pass', $hash_pass, SQLITE3_TEXT);
  $result = $stmt->execute();
  // COMMIT
  $db->exec('commit');
} catch (Exception $e) {
  // ROLLBACK
  $db->exec('rollback');
  $e->getTraceAsString();
  return;
}
$db->close();

// セッション情報のトークンを削除
unset($_SESSION['POST_TOKEN']);
return;
