/**
 * ハッシュパスの作成
 * @returns boolean
 */
function hashPass() {
  let err_msg = "";
  let id = $("#account_id").val().trim();
  let pass = $("#password").val().trim();

  //idチェック
  let id_reg = new RegExp(/^[0-9a-zA-Z]+$/);
  if (id_reg.test(id) == false) {
    err_msg += "IDは半角英数のみ入力可能です<br/>";
  }

  //パスワードチェック
  let pass_reg = new RegExp(/^[a-zA-Z0-9!-/:-@¥[-`{-~]+$/);
  if (pass_reg.test(pass) == false) {
    err_msg += "IDは半角英数記号のみ入力可能です<br/>";
  }

  //エラーがあれば、処理を中断しログイン画面に戻る
  if (err_msg !== "") {
    $(".err_msg").html(err_msg);
    return false;
  }

  //確認メッセージ内容の作成
  let html = "<div>ID  :" + id + "<br />PASS:" + pass + "</div>";

  //パスワードの作成処理
  swal
    .fire({
      title: "入力内容の確認",
      html: html,
      icon: "info",
      confirmButtonText: "作 成",
      showCancelButton: true,
      cancelButtonText: "キャンセル",
    })
    .then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          type: "POST",
          url: "proc/hash_pass.php",
          dataType: "text",
          data: {
            id: id,
            pass: pass,
          },
        })
          .done(function (data) {
            swal
              .fire({
                title: "ハッシュパスワードの作成",
                html: ".htpasswd作成エリアに追記しました",
                icon: "success",
                showCloseButton: true,
                confirmButtonText: "終　了",
              })
              .then(function (val) {
                console.log(data);
                let tmp = $("#htpasswd").val();
                $("#htpasswd").val(tmp + "\n" + data);
                $("#account_id").val("");
                $("#password").val("");
              });
          })
          .fail(function (XMLHttpRequest, textStatus, errorThrown) {
            swal.fire({
              title: "異常終了",
              text: "処理が異常終了しました。",
              icon: "error",
              showCloseButton: true,
            });
          });
      } else {
      }
    });
}

/**
 * ".htpasswdの作成
 */
function fileCreate() {
  let pw_data = $("#htpasswd").val();

  swal
    .fire({
      title: ".htpasswdファイルの更新",
      html: ".htpasswdファイルを更新して宜しいでしょうか？",
      icon: "info",
      confirmButtonText: "更　新",
      showCancelButton: true,
      cancelButtonText: "キャンセル",
    })
    .then((result) => {
      if (result.isConfirmed) {
        $.ajax({
          type: "POST",
          url: "proc/file_create.php",
          dataType: "text",
          data: {
            pw_data: pw_data,
          },
        })
          .done(function (data) {
            swal
              .fire({
                title: ".htpasswdファイルの更新",
                html: ".htpasswdファイルを更新しました",
                icon: "success",
                showCloseButton: true,
                confirmButtonText: "終　了",
              })
              .then(function (val) {
                console.log("終了");
              });
          })
          .fail(function (XMLHttpRequest, textStatus, errorThrown) {
            swal.fire({
              title: "異常終了",
              text: "処理が異常終了しました。",
              icon: "error",
              showCloseButton: true,
            });
          });
      } else {
      }
    });
}
