<?php

//セッションの開始
session_start();

//トークン(アクセスコード)の一致確認
if (filter_input(INPUT_POST, 'POST_TOKEN') != $_SESSION["POST_TOKEN"]) {
  // トークンが一致しない
  header("Location: ../login.html");
  exit;
}

//ログインフォームの情報を取得する
$email =  filter_input(INPUT_POST, 'email');
$password = filter_input(INPUT_POST, 'password');

/**
 * 入力チェック
 */
if ($email == "" || $password == "") {
  $_SESSION["ERR_MSG"] = "入力エラー";
  header("Location:../login.html");
  exit();
}



$db = new SQLite3('../admin/db/user.db');
$sql = "SELECT * FROM users where email=:email";
$stmt = $db->prepare($sql);
$stmt->bindValue(':email', $email, SQLITE3_TEXT);
$result = $stmt->execute();
$cnt = 0;
while ($row = $result->fetchArray()) {

  if (!password_verify($password, $row[2])) {
    $_SESSION["ERR_MSG"] = "メールアドレスまたはパスワードが正しくありません";
    header("Location:../login.html");
    exit();
  }
  $_SESSION["LOGIN_NAME"] = $row[1];
  $_SESSION["LOGIN_STATUS"] = $row[4];
  $cnt++;
}
if ($cnt == 0) {
  $_SESSION["ERR_MSG"] = "メールアドレスまたはパスワードが正しくありません2";
  header("Location:../login.html");
  exit();
}
session_write_close();
header("Location:../admin/index.html");
exit();
